<?php

    namespace App\Models;

    use Illuminate\Database\Eloquent\Model;

    /**
     * @method static where(string $string, mixed $id)
     * @method static create(array $array)
     */
    class ChatBoxMessage extends Model
    {
        protected $fillable = [
            'box_id',
            'message',
            'media_url',
            'sms_type',
            'direction',
            'sending_server_id',
            'send_by',
        ];

        public function chatBox()
        {
            return $this->belongsTo(ChatBox::class, 'box_id', 'id');
        }

    }
