<?php //b2db65a2178f1c39d87092b9b7f9c06e
/** @noinspection all */

namespace Codeglen\Ulanding\Models {

    use App\Models\User;
    use Illuminate\Database\Eloquent\Model;
    use Illuminate\Database\Eloquent\Relations\BelongsTo;
    use Illuminate\Database\Eloquent\Relations\BelongsToMany;
    use Illuminate\Database\Eloquent\Relations\HasMany;
    use Illuminate\Database\Eloquent\Relations\MorphTo;
    use Illuminate\Database\Eloquent\Relations\MorphToMany;
    use Illuminate\Support\Carbon;
    use LaravelIdea\Helper\App\Models\_IH_User_QB;
    use LaravelIdea\Helper\Codeglen\Ulanding\Models\_IH_BlogCategory_C;
    use LaravelIdea\Helper\Codeglen\Ulanding\Models\_IH_BlogCategory_QB;
    use LaravelIdea\Helper\Codeglen\Ulanding\Models\_IH_BlogComment_C;
    use LaravelIdea\Helper\Codeglen\Ulanding\Models\_IH_BlogComment_QB;
    use LaravelIdea\Helper\Codeglen\Ulanding\Models\_IH_BlogTag_C;
    use LaravelIdea\Helper\Codeglen\Ulanding\Models\_IH_BlogTag_QB;
    use LaravelIdea\Helper\Codeglen\Ulanding\Models\_IH_Blog_C;
    use LaravelIdea\Helper\Codeglen\Ulanding\Models\_IH_Blog_QB;
    use LaravelIdea\Helper\Codeglen\Ulanding\Models\_IH_Brands_C;
    use LaravelIdea\Helper\Codeglen\Ulanding\Models\_IH_Brands_QB;
    use LaravelIdea\Helper\Codeglen\Ulanding\Models\_IH_FormBuilder_C;
    use LaravelIdea\Helper\Codeglen\Ulanding\Models\_IH_FormBuilder_QB;
    use LaravelIdea\Helper\Codeglen\Ulanding\Models\_IH_MediaUploader_C;
    use LaravelIdea\Helper\Codeglen\Ulanding\Models\_IH_MediaUploader_QB;
    use LaravelIdea\Helper\Codeglen\Ulanding\Models\_IH_Menu_C;
    use LaravelIdea\Helper\Codeglen\Ulanding\Models\_IH_Menu_QB;
    use LaravelIdea\Helper\Codeglen\Ulanding\Models\_IH_PageBuilder_C;
    use LaravelIdea\Helper\Codeglen\Ulanding\Models\_IH_PageBuilder_QB;
    use LaravelIdea\Helper\Codeglen\Ulanding\Models\_IH_Page_C;
    use LaravelIdea\Helper\Codeglen\Ulanding\Models\_IH_Page_QB;
    use LaravelIdea\Helper\Codeglen\Ulanding\Models\_IH_PricePlan_C;
    use LaravelIdea\Helper\Codeglen\Ulanding\Models\_IH_PricePlan_QB;
    use LaravelIdea\Helper\Codeglen\Ulanding\Models\_IH_Testimonial_C;
    use LaravelIdea\Helper\Codeglen\Ulanding\Models\_IH_Testimonial_QB;
    use LaravelIdea\Helper\Codeglen\Ulanding\Models\_IH_Theme_C;
    use LaravelIdea\Helper\Codeglen\Ulanding\Models\_IH_Theme_QB;
    
    /**
     * @property int $id
     * @property string $uid
     * @property string $title
     * @property string $slug
     * @property string|null $summary
     * @property string $content
     * @property int|null $blog_category_id
     * @property string $status
     * @property Carbon|null $published_at
     * @property string|null $featured_image
     * @property string|null $meta_title
     * @property string|null $meta_description
     * @property int|null $user_id
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @property BlogCategory|null $category
     * @method BelongsTo|_IH_BlogCategory_QB category()
     * @property _IH_BlogComment_C|BlogComment[] $comments
     * @property-read int $comments_count
     * @method HasMany|_IH_BlogComment_QB comments()
     * @property _IH_BlogTag_C|BlogTag[] $tags
     * @property-read int $tags_count
     * @method BelongsToMany|_IH_BlogTag_QB tags()
     * @method static _IH_Blog_QB onWriteConnection()
     * @method _IH_Blog_QB newQuery()
     * @method static _IH_Blog_QB on(null|string|\UnitEnum $connection = null)
     * @method static _IH_Blog_QB query()
     * @method static _IH_Blog_QB with(array|string $relations)
     * @method _IH_Blog_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_Blog_C|Blog[] all($columns = ['*'])
     * @ownLinks blog_category_id,\Codeglen\Ulanding\Models\BlogCategory,id|user_id,\App\Models\User,id
     * @foreignLinks id,\Codeglen\Ulanding\Models\BlogComment,blog_id
     * @mixin _IH_Blog_QB
     */
    class Blog extends Model {}
    
    /**
     * @property int $id
     * @property string $name
     * @property string $slug
     * @property string|null $description
     * @property int|null $parent_id
     * @property bool $is_active
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @property _IH_Blog_C|Blog[] $blogs
     * @property-read int $blogs_count
     * @method HasMany|_IH_Blog_QB blogs()
     * @method static _IH_BlogCategory_QB onWriteConnection()
     * @method _IH_BlogCategory_QB newQuery()
     * @method static _IH_BlogCategory_QB on(null|string|\UnitEnum $connection = null)
     * @method static _IH_BlogCategory_QB query()
     * @method static _IH_BlogCategory_QB with(array|string $relations)
     * @method _IH_BlogCategory_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_BlogCategory_C|BlogCategory[] all($columns = ['*'])
     * @ownLinks parent_id,\Codeglen\Ulanding\Models\BlogCategory,id
     * @foreignLinks id,\Codeglen\Ulanding\Models\BlogCategory,parent_id|id,\Codeglen\Ulanding\Models\Blog,blog_category_id
     * @mixin _IH_BlogCategory_QB
     */
    class BlogCategory extends Model {}
    
    /**
     * @property int $id
     * @property int $blog_id
     * @property int|null $user_id
     * @property string|null $author_name
     * @property string|null $author_email
     * @property string $content
     * @property int|null $parent_id
     * @property string $status
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @property Blog $blog
     * @method BelongsTo|_IH_Blog_QB blog()
     * @property BlogComment|null $parent
     * @method BelongsTo|_IH_BlogComment_QB parent()
     * @property _IH_BlogComment_C|BlogComment[] $replies
     * @property-read int $replies_count
     * @method HasMany|_IH_BlogComment_QB replies()
     * @property User|null $user
     * @method BelongsTo|_IH_User_QB user()
     * @method static _IH_BlogComment_QB onWriteConnection()
     * @method _IH_BlogComment_QB newQuery()
     * @method static _IH_BlogComment_QB on(null|string|\UnitEnum $connection = null)
     * @method static _IH_BlogComment_QB query()
     * @method static _IH_BlogComment_QB with(array|string $relations)
     * @method _IH_BlogComment_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_BlogComment_C|BlogComment[] all($columns = ['*'])
     * @ownLinks blog_id,\Codeglen\Ulanding\Models\Blog,id|user_id,\App\Models\User,id|parent_id,\Codeglen\Ulanding\Models\BlogComment,id
     * @foreignLinks id,\Codeglen\Ulanding\Models\BlogComment,parent_id
     * @mixin _IH_BlogComment_QB
     */
    class BlogComment extends Model {}
    
    /**
     * @property int $id
     * @property string $name
     * @property string $slug
     * @property string|null $description
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @property _IH_Blog_C|Blog[] $blogs
     * @property-read int $blogs_count
     * @method BelongsToMany|_IH_Blog_QB blogs()
     * @method static _IH_BlogTag_QB onWriteConnection()
     * @method _IH_BlogTag_QB newQuery()
     * @method static _IH_BlogTag_QB on(null|string|\UnitEnum $connection = null)
     * @method static _IH_BlogTag_QB query()
     * @method static _IH_BlogTag_QB with(array|string $relations)
     * @method _IH_BlogTag_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_BlogTag_C|BlogTag[] all($columns = ['*'])
     * @foreignLinks 
     * @mixin _IH_BlogTag_QB
     */
    class BlogTag extends Model {}
    
    /**
     * @property int $id
     * @property string $uid
     * @property string $name
     * @property string $logo_path
     * @property string|null $website_url
     * @property string|null $alt_text
     * @property bool $is_published
     * @property int $sort_order
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @method static _IH_Brands_QB onWriteConnection()
     * @method _IH_Brands_QB newQuery()
     * @method static _IH_Brands_QB on(null|string|\UnitEnum $connection = null)
     * @method static _IH_Brands_QB query()
     * @method static _IH_Brands_QB with(array|string $relations)
     * @method _IH_Brands_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_Brands_C|Brands[] all($columns = ['*'])
     * @mixin _IH_Brands_QB
     */
    class Brands extends Model {}
    
    /**
     * @property int $id
     * @property string $uid
     * @property string $title
     * @property string|null $slug
     * @property string|null $email
     * @property string $button_text
     * @property array $fields
     * @property string|null $success_message
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @method static _IH_FormBuilder_QB onWriteConnection()
     * @method _IH_FormBuilder_QB newQuery()
     * @method static _IH_FormBuilder_QB on(null|string|\UnitEnum $connection = null)
     * @method static _IH_FormBuilder_QB query()
     * @method static _IH_FormBuilder_QB with(array|string $relations)
     * @method _IH_FormBuilder_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_FormBuilder_C|FormBuilder[] all($columns = ['*'])
     * @mixin _IH_FormBuilder_QB
     */
    class FormBuilder extends Model {}
    
    /**
     * @property int $id
     * @property string $file_name
     * @property string $disk
     * @property string|null $mime_type
     * @property int $size
     * @property string $path
     * @property array|null $manipulations
     * @property int $model_id
     * @property string $model_type
     * @property string|null $alt_text
     * @property int $order
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @property Model $model
     * @method MorphTo model()
     * @method static _IH_MediaUploader_QB onWriteConnection()
     * @method _IH_MediaUploader_QB newQuery()
     * @method static _IH_MediaUploader_QB on(null|string|\UnitEnum $connection = null)
     * @method static _IH_MediaUploader_QB query()
     * @method static _IH_MediaUploader_QB with(array|string $relations)
     * @method _IH_MediaUploader_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_MediaUploader_C|MediaUploader[] all($columns = ['*'])
     * @mixin _IH_MediaUploader_QB
     */
    class MediaUploader extends Model {}
    
    /**
     * @property int $id
     * @property string $name
     * @property string|null $url
     * @property string $slug
     * @property string|null $icon
     * @property int|null $parent_id
     * @property string $group
     * @property int $order
     * @property bool $is_active
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @property _IH_Menu_C|Menu[] $children
     * @property-read int $children_count
     * @method HasMany|_IH_Menu_QB children()
     * @property Menu|null $parent
     * @method BelongsTo|_IH_Menu_QB parent()
     * @method static _IH_Menu_QB onWriteConnection()
     * @method _IH_Menu_QB newQuery()
     * @method static _IH_Menu_QB on(null|string|\UnitEnum $connection = null)
     * @method static _IH_Menu_QB query()
     * @method static _IH_Menu_QB with(array|string $relations)
     * @method _IH_Menu_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_Menu_C|Menu[] all($columns = ['*'])
     * @ownLinks parent_id,\Codeglen\Ulanding\Models\Menu,id
     * @foreignLinks id,\Codeglen\Ulanding\Models\Menu,parent_id
     * @mixin _IH_Menu_QB
     */
    class Menu extends Model {}
    
    /**
     * @property int $id
     * @property string $uid
     * @property string $title
     * @property string $slug
     * @property string|null $template
     * @property string $content
     * @property string|null $meta_title
     * @property string|null $meta_description
     * @property bool $is_published
     * @property int $order
     * @property bool $breadcrumb
     * @property bool $page_builder
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @property _IH_PageBuilder_C|PageBuilder[] $pageBuilders
     * @property-read int $page_builders_count
     * @method MorphToMany|_IH_PageBuilder_QB pageBuilders()
     * @method static _IH_Page_QB onWriteConnection()
     * @method _IH_Page_QB newQuery()
     * @method static _IH_Page_QB on(null|string|\UnitEnum $connection = null)
     * @method static _IH_Page_QB query()
     * @method static _IH_Page_QB with(array|string $relations)
     * @method _IH_Page_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_Page_C|Page[] all($columns = ['*'])
     * @mixin _IH_Page_QB
     */
    class Page extends Model {}
    
    /**
     * @property int $id
     * @property string|null $addon_name
     * @property string|null $addon_type
     * @property string|null $addon_namespace
     * @property string|null $addon_location
     * @property int|null $addon_order
     * @property int|null $addon_page_id
     * @property string|null $addon_page_type
     * @property array|null $addon_settings
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @property Model $addonPage
     * @method MorphTo addonPage()
     * @method static _IH_PageBuilder_QB onWriteConnection()
     * @method _IH_PageBuilder_QB newQuery()
     * @method static _IH_PageBuilder_QB on(null|string|\UnitEnum $connection = null)
     * @method static _IH_PageBuilder_QB query()
     * @method static _IH_PageBuilder_QB with(array|string $relations)
     * @method _IH_PageBuilder_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_PageBuilder_C|PageBuilder[] all($columns = ['*'])
     * @mixin _IH_PageBuilder_QB
     */
    class PageBuilder extends Model {}
    
    /**
     * @property int $id
     * @property string $uid
     * @property string $title
     * @property string|null $subtitle
     * @property int|null $type
     * @property int $status
     * @property string $price
     * @property string|null $zero_price
     * @property bool $has_trial
     * @property int|null $trial_days
     * @property array|null $features
     * @property array|null $faq
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @method static _IH_PricePlan_QB onWriteConnection()
     * @method _IH_PricePlan_QB newQuery()
     * @method static _IH_PricePlan_QB on(null|string|\UnitEnum $connection = null)
     * @method static _IH_PricePlan_QB query()
     * @method static _IH_PricePlan_QB with(array|string $relations)
     * @method _IH_PricePlan_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_PricePlan_C|PricePlan[] all($columns = ['*'])
     * @mixin _IH_PricePlan_QB
     */
    class PricePlan extends Model {}
    
    /**
     * @property int $id
     * @property string $uid
     * @property string $content
     * @property string $author_name
     * @property string|null $author_title
     * @property string|null $author_image_path
     * @property int|null $rating
     * @property bool $is_published
     * @property int $sort_order
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @method static _IH_Testimonial_QB onWriteConnection()
     * @method _IH_Testimonial_QB newQuery()
     * @method static _IH_Testimonial_QB on(null|string|\UnitEnum $connection = null)
     * @method static _IH_Testimonial_QB query()
     * @method static _IH_Testimonial_QB with(array|string $relations)
     * @method _IH_Testimonial_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_Testimonial_C|Testimonial[] all($columns = ['*'])
     * @mixin _IH_Testimonial_QB
     */
    class Testimonial extends Model {}
    
    /**
     * @property int $id
     * @property string $title
     * @property string $slug
     * @property string $version
     * @property string|null $author
     * @property string|null $description
     * @property string|null $image
     * @property string|null $url
     * @property bool $is_active Whether this theme is currently applied/active
     * @property bool $is_public Whether this theme is available for users to select
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @method static _IH_Theme_QB onWriteConnection()
     * @method _IH_Theme_QB newQuery()
     * @method static _IH_Theme_QB on(null|string|\UnitEnum $connection = null)
     * @method static _IH_Theme_QB query()
     * @method static _IH_Theme_QB with(array|string $relations)
     * @method _IH_Theme_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_Theme_C|Theme[] all($columns = ['*'])
     * @mixin _IH_Theme_QB
     */
    class Theme extends Model {}
}