<?php

declare(strict_types=1);

/*
 * PaypalServerSdkLib
 *
 * This file was automatically generated by APIMATIC v3.0 ( https://www.apimatic.io ).
 */

namespace PaypalServerSdkLib\Models;

use stdClass;

/**
 * Additional attributes associated with apple pay.
 */
class ApplePayAttributes implements \JsonSerializable
{
    /**
     * @var CustomerInformation|null
     */
    private $customer;

    /**
     * @var VaultInstruction|null
     */
    private $vault;

    /**
     * Returns Customer.
     * The details about a customer in PayPal's system of record.
     */
    public function getCustomer(): ?CustomerInformation
    {
        return $this->customer;
    }

    /**
     * Sets Customer.
     * The details about a customer in PayPal's system of record.
     *
     * @maps customer
     */
    public function setCustomer(?CustomerInformation $customer): void
    {
        $this->customer = $customer;
    }

    /**
     * Returns Vault.
     * Base vaulting specification. The object can be extended for specific use cases within each
     * payment_source that supports vaulting.
     */
    public function getVault(): ?VaultInstruction
    {
        return $this->vault;
    }

    /**
     * Sets Vault.
     * Base vaulting specification. The object can be extended for specific use cases within each
     * payment_source that supports vaulting.
     *
     * @maps vault
     */
    public function setVault(?VaultInstruction $vault): void
    {
        $this->vault = $vault;
    }

    /**
     * Encode this object to JSON
     *
     * @param bool $asArrayWhenEmpty Whether to serialize this model as an array whenever no fields
     *        are set. (default: false)
     *
     * @return array|stdClass
     */
    #[\ReturnTypeWillChange] // @phan-suppress-current-line PhanUndeclaredClassAttribute for (php < 8.1)
    public function jsonSerialize(bool $asArrayWhenEmpty = false)
    {
        $json = [];
        if (isset($this->customer)) {
            $json['customer'] = $this->customer;
        }
        if (isset($this->vault)) {
            $json['vault']    = $this->vault;
        }

        return (!$asArrayWhenEmpty && empty($json)) ? new stdClass() : $json;
    }
}
