<?php

declare(strict_types=1);

/*
 * PaypalServerSdkLib
 *
 * This file was automatically generated by APIMATIC v3.0 ( https://www.apimatic.io ).
 */

namespace PaypalServerSdkLib\Models\Builders;

use Core\Utils\CoreHelper;
use PaypalServerSdkLib\Models\CapturePaymentInstruction;
use PaypalServerSdkLib\Models\CaptureRequest;
use PaypalServerSdkLib\Models\Money;

/**
 * Builder for model CaptureRequest
 *
 * @see CaptureRequest
 */
class CaptureRequestBuilder
{
    /**
     * @var CaptureRequest
     */
    private $instance;

    private function __construct(CaptureRequest $instance)
    {
        $this->instance = $instance;
    }

    /**
     * Initializes a new capture request Builder object.
     */
    public static function init(): self
    {
        return new self(new CaptureRequest());
    }

    /**
     * Sets invoice id field.
     */
    public function invoiceId(?string $value): self
    {
        $this->instance->setInvoiceId($value);
        return $this;
    }

    /**
     * Sets note to payer field.
     */
    public function noteToPayer(?string $value): self
    {
        $this->instance->setNoteToPayer($value);
        return $this;
    }

    /**
     * Sets amount field.
     */
    public function amount(?Money $value): self
    {
        $this->instance->setAmount($value);
        return $this;
    }

    /**
     * Sets final capture field.
     */
    public function finalCapture(?bool $value): self
    {
        $this->instance->setFinalCapture($value);
        return $this;
    }

    /**
     * Sets payment instruction field.
     */
    public function paymentInstruction(?CapturePaymentInstruction $value): self
    {
        $this->instance->setPaymentInstruction($value);
        return $this;
    }

    /**
     * Sets soft descriptor field.
     */
    public function softDescriptor(?string $value): self
    {
        $this->instance->setSoftDescriptor($value);
        return $this;
    }

    /**
     * Initializes a new capture request object.
     */
    public function build(): CaptureRequest
    {
        return CoreHelper::clone($this->instance);
    }
}
