<?php

declare(strict_types=1);

/*
 * PaypalServerSdkLib
 *
 * This file was automatically generated by APIMATIC v3.0 ( https://www.apimatic.io ).
 */

namespace PaypalServerSdkLib\Models\Builders;

use Core\Utils\CoreHelper;
use PaypalServerSdkLib\Models\ApplePayRequest;
use PaypalServerSdkLib\Models\BancontactPaymentRequest;
use PaypalServerSdkLib\Models\BlikPaymentRequest;
use PaypalServerSdkLib\Models\CardRequest;
use PaypalServerSdkLib\Models\EpsPaymentRequest;
use PaypalServerSdkLib\Models\GiropayPaymentRequest;
use PaypalServerSdkLib\Models\GooglePayRequest;
use PaypalServerSdkLib\Models\IdealPaymentRequest;
use PaypalServerSdkLib\Models\MybankPaymentRequest;
use PaypalServerSdkLib\Models\P24PaymentRequest;
use PaypalServerSdkLib\Models\PaymentSource;
use PaypalServerSdkLib\Models\PaypalWallet;
use PaypalServerSdkLib\Models\SofortPaymentRequest;
use PaypalServerSdkLib\Models\Token;
use PaypalServerSdkLib\Models\TrustlyPaymentRequest;
use PaypalServerSdkLib\Models\VenmoWalletRequest;

/**
 * Builder for model PaymentSource
 *
 * @see PaymentSource
 */
class PaymentSourceBuilder
{
    /**
     * @var PaymentSource
     */
    private $instance;

    private function __construct(PaymentSource $instance)
    {
        $this->instance = $instance;
    }

    /**
     * Initializes a new payment source Builder object.
     */
    public static function init(): self
    {
        return new self(new PaymentSource());
    }

    /**
     * Sets card field.
     */
    public function card(?CardRequest $value): self
    {
        $this->instance->setCard($value);
        return $this;
    }

    /**
     * Sets token field.
     */
    public function token(?Token $value): self
    {
        $this->instance->setToken($value);
        return $this;
    }

    /**
     * Sets paypal field.
     */
    public function paypal(?PaypalWallet $value): self
    {
        $this->instance->setPaypal($value);
        return $this;
    }

    /**
     * Sets bancontact field.
     */
    public function bancontact(?BancontactPaymentRequest $value): self
    {
        $this->instance->setBancontact($value);
        return $this;
    }

    /**
     * Sets blik field.
     */
    public function blik(?BlikPaymentRequest $value): self
    {
        $this->instance->setBlik($value);
        return $this;
    }

    /**
     * Sets eps field.
     */
    public function eps(?EpsPaymentRequest $value): self
    {
        $this->instance->setEps($value);
        return $this;
    }

    /**
     * Sets giropay field.
     */
    public function giropay(?GiropayPaymentRequest $value): self
    {
        $this->instance->setGiropay($value);
        return $this;
    }

    /**
     * Sets ideal field.
     */
    public function ideal(?IdealPaymentRequest $value): self
    {
        $this->instance->setIdeal($value);
        return $this;
    }

    /**
     * Sets mybank field.
     */
    public function mybank(?MybankPaymentRequest $value): self
    {
        $this->instance->setMybank($value);
        return $this;
    }

    /**
     * Sets p 24 field.
     */
    public function p24(?P24PaymentRequest $value): self
    {
        $this->instance->setP24($value);
        return $this;
    }

    /**
     * Sets sofort field.
     */
    public function sofort(?SofortPaymentRequest $value): self
    {
        $this->instance->setSofort($value);
        return $this;
    }

    /**
     * Sets trustly field.
     */
    public function trustly(?TrustlyPaymentRequest $value): self
    {
        $this->instance->setTrustly($value);
        return $this;
    }

    /**
     * Sets apple pay field.
     */
    public function applePay(?ApplePayRequest $value): self
    {
        $this->instance->setApplePay($value);
        return $this;
    }

    /**
     * Sets google pay field.
     */
    public function googlePay(?GooglePayRequest $value): self
    {
        $this->instance->setGooglePay($value);
        return $this;
    }

    /**
     * Sets venmo field.
     */
    public function venmo(?VenmoWalletRequest $value): self
    {
        $this->instance->setVenmo($value);
        return $this;
    }

    /**
     * Initializes a new payment source object.
     */
    public function build(): PaymentSource
    {
        return CoreHelper::clone($this->instance);
    }
}
