<?php

declare(strict_types=1);

/*
 * PaypalServerSdkLib
 *
 * This file was automatically generated by APIMATIC v3.0 ( https://www.apimatic.io ).
 */

namespace PaypalServerSdkLib\Models\Builders;

use Core\Utils\CoreHelper;
use PaypalServerSdkLib\Models\Address;
use PaypalServerSdkLib\Models\PaymentTokenRequestCard;

/**
 * Builder for model PaymentTokenRequestCard
 *
 * @see PaymentTokenRequestCard
 */
class PaymentTokenRequestCardBuilder
{
    /**
     * @var PaymentTokenRequestCard
     */
    private $instance;

    private function __construct(PaymentTokenRequestCard $instance)
    {
        $this->instance = $instance;
    }

    /**
     * Initializes a new payment token request card Builder object.
     */
    public static function init(): self
    {
        return new self(new PaymentTokenRequestCard());
    }

    /**
     * Sets name field.
     */
    public function name(?string $value): self
    {
        $this->instance->setName($value);
        return $this;
    }

    /**
     * Sets number field.
     */
    public function number(?string $value): self
    {
        $this->instance->setNumber($value);
        return $this;
    }

    /**
     * Sets expiry field.
     */
    public function expiry(?string $value): self
    {
        $this->instance->setExpiry($value);
        return $this;
    }

    /**
     * Sets security code field.
     */
    public function securityCode(?string $value): self
    {
        $this->instance->setSecurityCode($value);
        return $this;
    }

    /**
     * Sets brand field.
     */
    public function brand(?string $value): self
    {
        $this->instance->setBrand($value);
        return $this;
    }

    /**
     * Sets billing address field.
     */
    public function billingAddress(?Address $value): self
    {
        $this->instance->setBillingAddress($value);
        return $this;
    }

    /**
     * Sets network transaction reference field.
     */
    public function networkTransactionReference($value): self
    {
        $this->instance->setNetworkTransactionReference($value);
        return $this;
    }

    /**
     * Initializes a new payment token request card object.
     */
    public function build(): PaymentTokenRequestCard
    {
        return CoreHelper::clone($this->instance);
    }
}
