<?php

declare(strict_types=1);

/*
 * PaypalServerSdkLib
 *
 * This file was automatically generated by APIMATIC v3.0 ( https://www.apimatic.io ).
 */

namespace PaypalServerSdkLib\Models\Builders;

use Core\Utils\CoreHelper;
use PaypalServerSdkLib\Models\ApplePayPaymentToken;
use PaypalServerSdkLib\Models\CardPaymentToken;
use PaypalServerSdkLib\Models\PaymentTokenResponsePaymentSource;
use PaypalServerSdkLib\Models\PaypalPaymentToken;
use PaypalServerSdkLib\Models\VenmoPaymentToken;

/**
 * Builder for model PaymentTokenResponsePaymentSource
 *
 * @see PaymentTokenResponsePaymentSource
 */
class PaymentTokenResponsePaymentSourceBuilder
{
    /**
     * @var PaymentTokenResponsePaymentSource
     */
    private $instance;

    private function __construct(PaymentTokenResponsePaymentSource $instance)
    {
        $this->instance = $instance;
    }

    /**
     * Initializes a new payment token response payment source Builder object.
     */
    public static function init(): self
    {
        return new self(new PaymentTokenResponsePaymentSource());
    }

    /**
     * Sets card field.
     */
    public function card(?CardPaymentToken $value): self
    {
        $this->instance->setCard($value);
        return $this;
    }

    /**
     * Sets paypal field.
     */
    public function paypal(?PaypalPaymentToken $value): self
    {
        $this->instance->setPaypal($value);
        return $this;
    }

    /**
     * Sets venmo field.
     */
    public function venmo(?VenmoPaymentToken $value): self
    {
        $this->instance->setVenmo($value);
        return $this;
    }

    /**
     * Sets apple pay field.
     */
    public function applePay(?ApplePayPaymentToken $value): self
    {
        $this->instance->setApplePay($value);
        return $this;
    }

    /**
     * Sets bank field.
     */
    public function bank($value): self
    {
        $this->instance->setBank($value);
        return $this;
    }

    /**
     * Initializes a new payment token response payment source object.
     */
    public function build(): PaymentTokenResponsePaymentSource
    {
        return CoreHelper::clone($this->instance);
    }
}
