<?php

declare(strict_types=1);

/*
 * PaypalServerSdkLib
 *
 * This file was automatically generated by APIMATIC v3.0 ( https://www.apimatic.io ).
 */

namespace PaypalServerSdkLib\Models\Builders;

use Core\Utils\CoreHelper;
use PaypalServerSdkLib\Models\ExchangeRate;
use PaypalServerSdkLib\Models\Money;
use PaypalServerSdkLib\Models\SellerReceivableBreakdown;

/**
 * Builder for model SellerReceivableBreakdown
 *
 * @see SellerReceivableBreakdown
 */
class SellerReceivableBreakdownBuilder
{
    /**
     * @var SellerReceivableBreakdown
     */
    private $instance;

    private function __construct(SellerReceivableBreakdown $instance)
    {
        $this->instance = $instance;
    }

    /**
     * Initializes a new seller receivable breakdown Builder object.
     */
    public static function init(Money $grossAmount): self
    {
        return new self(new SellerReceivableBreakdown($grossAmount));
    }

    /**
     * Sets paypal fee field.
     */
    public function paypalFee(?Money $value): self
    {
        $this->instance->setPaypalFee($value);
        return $this;
    }

    /**
     * Sets paypal fee in receivable currency field.
     */
    public function paypalFeeInReceivableCurrency(?Money $value): self
    {
        $this->instance->setPaypalFeeInReceivableCurrency($value);
        return $this;
    }

    /**
     * Sets net amount field.
     */
    public function netAmount(?Money $value): self
    {
        $this->instance->setNetAmount($value);
        return $this;
    }

    /**
     * Sets receivable amount field.
     */
    public function receivableAmount(?Money $value): self
    {
        $this->instance->setReceivableAmount($value);
        return $this;
    }

    /**
     * Sets exchange rate field.
     */
    public function exchangeRate(?ExchangeRate $value): self
    {
        $this->instance->setExchangeRate($value);
        return $this;
    }

    /**
     * Sets platform fees field.
     */
    public function platformFees(?array $value): self
    {
        $this->instance->setPlatformFees($value);
        return $this;
    }

    /**
     * Initializes a new seller receivable breakdown object.
     */
    public function build(): SellerReceivableBreakdown
    {
        return CoreHelper::clone($this->instance);
    }
}
